package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.user;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AllocateWeCustomerParam extends BaseParam {

    private AllocateWeCustomerParamBean paramBean;
    @Data
    public static class AllocateWeCustomerParamBean implements Serializable {

        /**
         * 外部联系人的userid，注意不是企业成员的帐号
         */
        @JSONField(name = "handover_userid")
        private String handoverUserId;

        /**
         * 原跟进成员的userid
         */
        @JSONField(name = "external_userid")
        private String externalUserId;

        /**
         * 接替成员的userid
         */
        @JSONField(name = "takeover_userid")
        private String takeOverUserId;

        /**转移成功后发给客户的消息，最多200个字符，不填则使用默认文案，目前只对在职成员分配客户的情况生效*/
        @JSONField(name = "transfer_success_msg")
        private String transferSuccessMsg;

    }
}
