package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.user;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WeUserParam extends BaseParam {

    private WeUserParamBean paramBean;

    @Data
    public static class WeUserParamBean implements Serializable {

        //成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
        @JSONField(name = "avatar_mediaid")
        private String avatarMediaId;
        @JSONField(name = "avatar")
        private String avatar;

        //姓名
        @JSONField(name = "name")
        private String name;
        //昵称
        @JSONField(name = "alias")
        private String alias;
        //账号
        @JSONField(name = "userid")
        private String userId;

        //性别。1表示男性，2表示女性
        @JSONField(name = "gender")
        private Integer gender;

        //手机号码。企业内必须唯一，mobile/email二者不能同时为空
        @JSONField(name = "mobile")
        private String mobile;

        //邮箱
        @JSONField(name = "email")
        private String email;

        //成员所属部门id列表,不超过100个
        @JSONField(name = "department")
        private String[] department;

        //职位
        @JSONField(name = "position")
        private String position;

        //身份:表示在所在的部门内是否为上级。1表示为上级，0表示非上级。
        @JSONField(name = "is_leader_in_dept")
        private String[] isLeaderInDept;

        //启用/禁用成员。1表示启用成员，0表示禁用成员
        @JSONField(name = "enable")
        private Integer enable;

        //座机。32字节以内，由纯数字或’-‘号组成。
        @JSONField(name = "telephone")
        private String telephone;

        //地址
        @JSONField(name = "address")
        private String address;

        //全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取
        @JSONField(name = "open_userid")
        private String openUserId;

        //激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。
        @JSONField(name = "status")
        private Integer status;



    }
}
