package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.auth.provider;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/15
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ProviderLoginResult extends BaseResult {

    /**
     * 登录用户的类型：1.创建者 2.内部系统管理员 3.外部系统管理员 4.分级管理员 5.成员
     */
    @JSONField(name = "usertype")
    private Integer userType;

    /**
     * 登录用户的信息
     */
    @JSONField(name = "user_info")
    ProviderLoginUserInfoBean userInfo;

    /**
     * 授权方企业信息
     */
    @JSONField(name = "corp_info")
    ProviderLoginCorpInfoBean corpInfo;

    /**
     * 该管理员在该提供商中能使用的应用列表，当登录用户为管理员时返回
     */
    @JSONField(name = "agent")
    List<ProviderLoginAgentInfoBean> agentList;

    /**
     * 该管理员拥有的通讯录权限，当登录用户为管理员时返回
     */
    @JSONField(name = "auth_info")
    ProviderLoginAuthInfoBean authInfo;

}
