package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 客户群相关
 * @author: HaoN
 * @create: 2020-10-20 21:52
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerGroupDetailResult extends BaseResult {

    private static final long serialVersionUID = 1710156275300792362L;
    @JSONField(name = "group_chat")
    private List<GroupChat> groupChatList;


    @Data
    public static class GroupChat implements Serializable {

        private static final long serialVersionUID = 5621644092633200049L;
        /**客户群ID*/
        @JSONField(name = "chat_id")
        private String chatId;


        /**群名*/
        private String name;

        /**群主ID*/
        private String owner;

        /**群的创建时间*/
        @JSONField(name = "create_time")
        private long createTime;

        /**群公告*/
        private String notice;

        /**群成员列表*/
        @JSONField(name = "member_list")
        private List<CustomerGroupMemberResult> memberList;

        /**群管理员列表*/
        @JSONField(name = "admin_list")
        private List<Admin> admins;

    }


    @Data
    public static class Admin implements Serializable{
        private static final long serialVersionUID = -3850603430381686659L;
        private String userid;

    }

}
