package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.agent.AgentDetailParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.agent.FindAgentParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.agent.AgentDetailResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.agent.AgentListResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeAppService {

    /**
     * 获取企业应用列表
     * @return
     */
    ScrmResult<AgentListResult> findAgentList(BaseParam param);

    /**
     * 根据应用id获取应用详情
     * @param param
     * @return
     */
    ScrmResult<AgentDetailResult> findAgentById(FindAgentParam param);

    /**
     * 设置应用
     * @param param
     * @return
     */
    ScrmResult<BaseResult> updateAgentById(AgentDetailParam param);
}
