package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.*;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.*;


/**
 * @author xiaotian
 * @description
 * @date ：Created in 2021/7/7
 */
@AdvancedFeignClient
public interface RemoteCustomerService {

    /**
     * 获取配置了客户联系功能的成员列表
     * @return
     */
    ScrmResult<FollowUserListResult> getFollowUserList(BaseParam param);


    /**
     * 获取指定企业服务管理人员所有用的客户id
     * @param param 企业服务管理人员id（具有外部联系功能的员工）
     * @return
     */
    ScrmResult<ExternalUserListResult> list(CustomerListParam param);


    /**
     * 根据客户id获取客户详情
     * @param param
     * @return
     */
    ScrmResult<ExternalUserDetailResult> get(CustomerDetailParam param);

    /**
     * 根据企业成员id批量获取客户详情
     * @param param
     * @return
     */
    ScrmResult<ExternalUserListResult> getByUser(GetByUserParam param);


    /**
     *  修改客户备注信息
     * @param weCustomerRemark
     * @return
     */
    ScrmResult<BaseResult> remark(WeCustomerParam weCustomerRemark);


    /**
     * 编辑客户标签
     * @return
     */
    ScrmResult<BaseResult> makeCustomerLabel(CutomerTagEditParam cutomerTagEditParam);


    /**
     * 客户发送欢迎语
     */
    ScrmResult<BaseResult> sendWelcomeMsg(WeWelcomeMsgParam weWelcomeMsgParam);


    /**
     * unionid转换external_userid
     * @return
     */
    ScrmResult<ExternalUserDetailResult> unionidToExternalUserid(ExternalContactConvertUnionIdParam param);


    /**
     * 联系客户统计
     * @return
     */
    ScrmResult<UserBehaviorDataResult> getUserBehaviorData(UserBehaviorDataQueryParam query);

    /**
     * 群聊数据统计（按群主聚合的方式）
     * @return
     */
    ScrmResult<GroupChatStatisticResult> getGroupChatStatistic(GroupChatStatisticQueryParam query);

    /**
     * 群聊数据统计(按自然日聚合的方式)
     * @return
     */
    ScrmResult<GroupChatStatisticResult> getGroupChatStatisticGroupByDay(GroupChatStatisticQueryParam query);

}
