package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.dept;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.dept.DeartMentParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.dept.DelDeptParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.dept.DeptListParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.dept.WeDepartMentResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeDeptService {

    /**
     * 创建部门
     * @param param
     * @return
     */
    ScrmResult<BaseResult> createWeDepartMent(DeartMentParam param);



    /**
     * 更新部门
     * @param param
     * @return
     */
    ScrmResult<BaseResult> updateWeDepartMent(DeartMentParam param);


    /**
     * 通过部门id删除部门 （注：不能删除根部门；不能删除含有子部门、成员的部门）
     * @param param
     * @return
     */
    ScrmResult<BaseResult> deleteWeDepartMent(DelDeptParam param);


    /**
     * 获取部门列表
     * @return  @Query("id") Long id
     */
    ScrmResult<WeDepartMentResult> weDepartMents(DeptListParam param);



    /**
     * 获取所有部门列表
     * @return
     */
    ScrmResult<WeDepartMentResult> weAllDepartMents(BaseParam param);




}
