package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.media.UploadMediaParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.media.UploadTempImgParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.result.UploadImgResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.result.UploadResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/19
 */
@AdvancedFeignClient
public interface RemoteUploadService {

    /**
     * 上传图片
     * @param param
     * @return
     */
    ScrmResult<UploadImgResult> uploadImg(UploadMediaParam param);

    /**
     * 上传媒体文件
     * @param param
     * @return
     */
    ScrmResult<UploadResult> upload(UploadMediaParam param);


    /**
     * 上传临时图片文件
     * @param param
     * @return
     */
    ScrmResult<UploadResult> uploadTempImg(UploadTempImgParam param);
}
