package cn.com.duiba.scrm.wechat.service.annotation;


import cn.com.duiba.scrm.wechat.service.enums.HttpRequestMethod;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName HttpBean.java
 * @Description TODO
 * @createTime 2021年07月05日 16:12:00
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface HttpBean {

    /**
     * HTTP url路径
     *
     * @return
     */
    String url() default "";

    /**
     * http url后面的路径
     *
     * @return
     */
    String path() default "";

    /**
     * 如果path()不为"",这此方法不生效
     * 如果为true并且path()返回的是"",则会将方法名称作为path
     * @return
     */
    boolean pathMethodName() default true;

    /**
     * 请求类型
     *
     * @return
     */
    HttpRequestMethod method() default HttpRequestMethod.NULL;


}
