package cn.com.duiba.scrm.wechat.service.bo;

import cn.com.duiba.scrm.wechat.service.annotation.HttpBean;
import cn.com.duiba.scrm.wechat.service.enums.HttpRequestMethod;
import cn.com.duiba.scrm.wechat.service.factorybean.HttpFactoryBean;
import lombok.Data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName HttpRequestParam.java
 * @Description TODO
 * @createTime 2021年07月24日 15:22:00
 */
@Data
public class HttpRequestParam {
    private Method method;
    private HttpBean methodAnnotation;
    private Annotation[][] parameterAnnotations;
    private HttpFactoryBean httpFactoryBean;
    private Object[] args;
    private HttpRequestMethod httpRequestMethod;

    public HttpRequestParam( HttpFactoryBean httpFactoryBean,Method method,Object[] args) {
        this.method = method;
        this.httpFactoryBean = httpFactoryBean;
        this.args = args;
        //方法的注解
        this.methodAnnotation = method.getAnnotation(HttpBean.class);
        //参数的注解
        this.parameterAnnotations = method.getParameterAnnotations();
    }
}
