package cn.com.duiba.scrm.wechat.service.factorybean;

import cn.com.duiba.scrm.wechat.service.enums.HttpRequestMethod;
import cn.com.duiba.scrm.wechat.service.proxy.DefaultHttpProxy;
import cn.com.duiba.scrm.wechat.service.proxy.HttpProxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName HttpFactoryBean.java
 * @Description http的工厂bean
 * @createTime 2021年07月05日 16:10:00
 */
public class HttpFactoryBean implements FactoryBean<Object>, InitializingBean, ApplicationContextAware {
    private ApplicationContext applicationContext;
    /**
     * 类型
     */
    private Class<?> type;
    /**
     * 请求地址
     */
    private String url;
    /**
     * 是否使用方法名称作为路径
     */
    private boolean pathMethodName;
    /**
     * 请求类型
     */
    private HttpRequestMethod method;


    @Override
    public Object getObject() throws Exception {
        HttpProxy bean = new DefaultHttpProxy(this);
        return bean.newProxyInstance();
    }

    @Override
    public Class<?> getObjectType() {
        return type;
    }

    @Override
    public void afterPropertiesSet() throws Exception {

    }

    @Override
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Class<?> getType() {
        return type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpRequestMethod getMethod() {
        return method;
    }

    public void setMethod(HttpRequestMethod method) {
        this.method = method;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public boolean isPathMethodName() {
        return pathMethodName;
    }

    public void setPathMethodName(boolean pathMethodName) {
        this.pathMethodName = pathMethodName;
    }

}