package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signpet.PetToyStatusEnum;
import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetPurchasedToyDto implements Serializable{
    private static final long serialVersionUID = -2480305431852203022L;
    /**
     * id
     **/
    private Long id;
    /**
     * 宠物ID
     **/
    private Long petId;
    /**
     * 道具标识
     */
    private String identifier;
    /**
     * 道具名称
     **/
    private String toyName;
    /**
     * 使用时是否有状态(0-否，1-是)
     **/
    private Boolean withStatus;
    /**
     * 持续时间(分钟)
     **/
    private Integer duration;
    /**
     * 状态(0-处理中 1-可用 2-已使用)
     **/
    private PetToyStatusEnum toyStatus;
    /**
     * 道具功能描述
     */
    private String description;

    public SignPetPurchasedToyDto(){}

    public SignPetPurchasedToyDto(SignPetActivityToyDto petActivityToy){
        this.description = petActivityToy.getDescription();
        this.identifier=petActivityToy.getIdentifier();
        this.toyName=petActivityToy.getToyName();
        this.withStatus=petActivityToy.getWithStatus();
        this.duration=petActivityToy.getDuration();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPetId() {
        return petId;
    }

    public void setPetId(Long petId) {
        this.petId = petId;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getToyName() {
        return toyName;
    }

    public void setToyName(String toyName) {
        this.toyName = toyName;
    }

    public Boolean getWithStatus() {
        return withStatus;
    }

    public void setWithStatus(Boolean withStatus) {
        this.withStatus = withStatus;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public PetToyStatusEnum getToyStatus() {
        return toyStatus;
    }

    public void setToyStatus(PetToyStatusEnum toyStatus) {
        this.toyStatus = toyStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
