package cn.com.duiba.sign.center.api.enums.signcontract;

/**
 * 契约完成状态
 * 初始化-》扣积分失败
 * 初始化-》扣积分成功-》进行中-》失败
 * 初始化-》扣积分成功-》进行中-》失败/已完成-》已领奖
 * Created by xiaoxuda on 2018/6/5.
 */
public enum SignContractDoneStatusEnum {
    INIT(0, "初始化"),
    DOING(1, "进行中"),
    DONE(2, "已完成"),
    FAIL(3, "失败"),
    CREDITS_FAIL(4, "扣积分失败"),
    REWARD(5, "已领奖");

    private Integer code;
    private String desc;

    SignContractDoneStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static SignContractDoneStatusEnum getByCode(Integer code){
        if(code == null){
            return null;
        }
        for(SignContractDoneStatusEnum type : values()){
            if(type.getCode().equals(code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
