package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignActivitySkinDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivitySkinStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.params.SignActivitySkinQueryParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
@AdvancedFeignClient
public interface RemoteSignActivitySkinService {
    /**
     * 新增签到体系活动皮肤，保存成功返回皮肤ID
     *
     * @param dto
     * @return 活动ID
     */
    Long insert(SignActivitySkinDto dto);

    /**
     * 删除签到活动皮肤
     *
     * @param id
     * @return
     */
    Boolean deleteSignActivitySkin(long id) throws BizException;

    /**
     * 更新指定ID的签到活动信息,不更新null值
     *
     * @param dto id非空
     * @return
     */
    Integer updateByIdUnNULL(SignActivitySkinDto dto);

    /**
     * 根据ID查询签到活动皮肤
     *
     * @param id
     * @return
     */
    SignActivitySkinDto find(long id);

    /**
     * 获取给定类型下的一个签到活动皮肤
     *
     * @param signType
     * @return
     */
    SignActivitySkinDto findOneByType(SignActivityTypeEnum signType);

    /**
     * 查询指定类型下给定app可用的签到活动皮肤，皮肤状态为开启，根据定向做过滤
     *
     * @param appId 非空
     * @return
     */
    List<SignActivitySkinDto> findByTypeAndAppId(SignActivityTypeEnum signType, long appId);

    /**
     * 分页查询签到活动,分页信息非空
     *
     * @param param
     * @return
     */
    List<SignActivitySkinDto> pageSearch(SignActivitySkinQueryParam param);

    /**
     * 符合条件的皮肤数量统计
     * @param param
     * @return
     */
    Integer count4PageSearch(SignActivitySkinQueryParam param);


    /**
     * 更新签到活动皮肤状态
     *
     * @param id
     * @param status
     * @return
     */
    Boolean updateStatus(long id, SignActivitySkinStatusEnum status);

    /**
     * 定向开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    Boolean directSwitch(long id, boolean switchOpen) throws BizException;
}
