package cn.com.duiba.sign.center.api.remoteservice.signcontract;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignContractBetDto;
import cn.com.duiba.sign.center.api.dto.SignContractIssueDto;
import cn.com.duiba.sign.center.api.params.SignContractBetUKParam;
import cn.com.duiba.sign.center.api.params.SignContractGetWardParam;
import cn.com.duiba.sign.center.api.params.SignContractJoinParam;
import cn.com.duiba.sign.center.api.params.SignContractSignParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/6/6.
 */
@AdvancedFeignClient
public interface RemoteSignContractMobileService {
    /**
     * 查询给定活动下未完成的契约
     * @param param
     * @return
     */
    SignContractBetDto findUndoneBet(SignContractBetUKParam param);

    /**
     * 查询期次信息
     * @return
     */
    SignContractIssueDto findById(Long issueId);

    /**
     * 批量查询期次信息
     * @param issueIds
     * @return
     */
    List<SignContractIssueDto> findByIds(List<Long> issueIds);

    /**
     * 查询所有参与记录
     * @param param
     * @return
     */
    List<SignContractBetDto> findJoinedByAct(SignContractBetUKParam param);

    /**
     * 参与契约, 如果有未完成契约且契约已过期或已中断不可补救，则直接将此类契约置为失败，之后再新建契约
     * @param param
     * @return
     */
    SignContractIssueDto joinContract(SignContractJoinParam param);

    /**
     * 打卡
     * @return 打卡记录ID
     * @exception
     */
    Long doSign(SignContractSignParam param) throws BizException;

    /**
     * 领奖
     * @param param
     * @return
     */
    Boolean getReward(SignContractGetWardParam param) throws BizException;
}
