package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/4/27
 * @description: 宠物吃饱状态
 */
public enum PetFullStatusEnum {
    PET_FULL_STATUS_YES(1,"吃饱"),
    PET_FULL_STATUS_NO(2,"饥饿")
    ;
    private String desc;
    private int code;

    PetFullStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,PetFullStatusEnum> typeMap = new HashMap<>();
    static{
        for(PetFullStatusEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PetFullStatusEnum getEnumByCode(Integer code){
        if(code == null || !typeMap.containsKey(code)){
            throw new SignCenterException("不支持的吃饱状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
