package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/4/25
 * @description: 宠物状态枚举
 */
public enum SignPetStatusTypeEnum {

    PET_STATUS_TYPE_LEAD(1,"主动状态"),
    PET_STATUS_TYPE_PASSIVE(2,"被动状态")
    ;
    private String desc;
    private int code;

    SignPetStatusTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,SignPetStatusTypeEnum> typeMap = new HashMap<>();
    static{
        for(SignPetStatusTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static SignPetStatusTypeEnum getEnumByCode(Integer code){
        if(code == null || !typeMap.containsKey(code)){
            throw new SignCenterException("不支持的宠物状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
