package cn.com.duiba.sign.center.api.exception;

/**
 * 活动中心业务异常
 * Created by xiaoxuda on 2017/4/20.
 */
public class SignCenterException extends RuntimeException{
    private static final long serialVersionUID = -6352918103285006028L;

    private final String errCode;

    /**
     * 继承父类
     */
    public SignCenterException(){
        super();
        errCode = null;
    }

    /**
     * 继承父类
     * @param message
     */
    public SignCenterException(String message){
        super(message);
        errCode = null;
    }

    public SignCenterException(String errCode, String message){
        super(message);
        this.errCode = errCode;
    }

    /**
     * 继承父类
     * @param e
     */
    public SignCenterException(Exception e){
        super(e);
        errCode = null;
    }

    public String getErrCode() {
        return errCode;
    }

}
