package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetActivityDto;
import cn.com.duiba.sign.center.api.params.SignPetActQueryParam;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description: 签到宠物养成活动
 */
@AdvancedFeignClient
public interface RemoteSignPetActivityService {
    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return 活动ID
     */
    Long insert(SignPetActivityDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    int deleteById(Long id);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int updateById(SignPetActivityDto dto);
    /**
     * 根据主键查询对应数据条目
     * @param id
     * @return
     */
    SignPetActivityDto findById(Long id);
    /**
     * 分页查询
     * @param param
     * @return
     */
    List<SignPetActivityDto> pageFind(SignPetActQueryParam param);

    /**
     * 符合条件的总数量
     * @param param
     * @return
     */
    Long pageCount(SignPetActQueryParam param);
}
