package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetDto;
import cn.com.duiba.sign.center.api.enums.signpet.PetFeedTypeEnum;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description: 签到宠物相关服务
 */
@AdvancedFeignClient
public interface RemoteSignPetService {

    /**
     * 宠物是否吃饱的状态
     * @return
     */
    boolean fullState(long petId);

    /**
     * 宠物喂食
     * @param petId 宠物id
     * @param consumerId 用户id
     * @param feedNum (如果喂食时明确知道喂食数量，则传喂食数量 否则传饲养员剩余粮食量，实际处理已设置的每次限制喂食量为准)
     */
    void feedPet(long petId,long consumerId, int feedNum)throws BizException;

    /**
     * 查询用户是否拥有宠物
     * @param activityId
     * @param feedType : 私人/群体
     * @param consumerId
     * @return
     */
     SignPetDto findByActIdAndOwner(long activityId, PetFeedTypeEnum feedType,long consumerId);

    /**
     * 初始化宠物数据
     * @param dto
     * @param appId
     * @param partnerUserId
     * @return
     */
    SignPetDto initPet(SignPetDto dto,long appId,String partnerUserId);

    /**
     * 主键查询
     * @param id
     * @return
     */
    SignPetDto findById(long id);

    /**
     * 更新
     * @param dto
     * @return
     */
    Integer update(SignPetDto dto);
}
