package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.PetCurrentStatusDto;
import cn.com.duiba.sign.center.api.dto.SignPetStatusDto;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusEnum;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusTypeEnum;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description: 签到宠物状态（管理后台）
 */
@AdvancedFeignClient
public interface RemoteSignPetStatusService {

    /**
     * 获取宠物当期状态
     * @param petId
     * @return
     */
    PetCurrentStatusDto getPetStatus(long petId);

    /**
     * 状态查询
     * @param activityId
     * @param status
     * @return
     */
    SignPetStatusDto getStatusByActAndCode(long activityId ,SignPetStatusEnum status);

}
