package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signpet.PetFeedTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetDto implements Serializable{

    private static final long serialVersionUID = 1141636361708546594L;

    /**
     * id
     **/
    private Long id;
    /**
     * 应用id
     */
    private Long appId;
    /**
     * 活动ID
     **/
    private Long activityId;

    /**
     * 宠物名称
     **/
    private String petName;
    /**
     * 宠物级别
     **/
    private Integer petLevel = 0;
    /**
     * 宠物当前状态
     **/
    private SignPetStatusEnum petStatus;
    /**
     * 所有者类型：1：个人，2：群组
     **/
    private PetFeedTypeEnum feedType;
    /**
     * 所有者ID
     **/
    private String ownerId;
    /**
     * 累计接收到的食物
     **/
    private Integer totalReceivedNum = 0;
    /**
     * 累计消耗的食物
     **/
    private Integer totalEatNum = 0;
    /**
     * 状态过期时间
     **/
    private Date statusExpireTime;
    /**
     * 经验值
     */
    private Integer petExp;


    public Long getId() {
        return id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    public Integer getPetLevel() {
        return petLevel;
    }

    public void setPetLevel(Integer petLevel) {
        this.petLevel = petLevel;
    }

    public SignPetStatusEnum getPetStatus() {
        return petStatus;
    }

    public void setPetStatus(SignPetStatusEnum petStatus) {
        this.petStatus = petStatus;
    }

    public PetFeedTypeEnum getFeedType() {
        return feedType;
    }

    public void setFeedType(PetFeedTypeEnum feedType) {
        this.feedType = feedType;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Integer getTotalReceivedNum() {
        return totalReceivedNum;
    }

    public void setTotalReceivedNum(Integer totalReceivedNum) {
        this.totalReceivedNum = totalReceivedNum;
    }

    public Integer getTotalEatNum() {
        return totalEatNum;
    }

    public void setTotalEatNum(Integer totalEatNum) {
        this.totalEatNum = totalEatNum;
    }

    public Date getStatusExpireTime() {
        return statusExpireTime;
    }

    public void setStatusExpireTime(Date statusExpireTime) {
        this.statusExpireTime = statusExpireTime;
    }

    public Integer getPetExp() {
        return petExp;
    }

    public void setPetExp(Integer petExp) {
        this.petExp = petExp;
    }
}
