package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignActivityDto;
import cn.com.duiba.sign.center.api.dto.SignActivitySimpleDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.params.SignActivityQueryParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
@AdvancedFeignClient
public interface RemoteSignActivityService {
    /**
     * 新增签到体系活动，保存成功返回活动ID
     *
     * @param dto
     * @return 活动ID
     */
    Long insert(SignActivityDto dto);

    /**
     * 删除签到活动
     *
     * @param id
     * @return
     */
    Boolean deleteSignActivity(long id) throws BizException;

    /**
     * 更新指定ID的签到活动信息，不更新null值
     *
     * @param dto id非空
     * @return
     */
    Integer updateByIdUnNULL(SignActivityDto dto);

    /**
     * 根据ID查询签到活动
     *
     * @param id
     * @return
     */
    SignActivityDto find(long id);

    /**
     * 获取给定类型下的一个签到活动
     *
     * @param signType
     * @return
     */
    SignActivityDto findOneByType(SignActivityTypeEnum signType);

    /**
     * 查询给定app可用的签到活动，根据定向和黑名单做过滤
     *
     * @param appId       非空
     * @param developerId 非空
     * @return
     */
    List<SignActivityDto> findByAppIdAndDeveloperId(long appId, long developerId);

    /**
     * 分页查询签到活动,分页信息非空
     *
     * @param param
     * @return
     */
    List<SignActivityDto> pageSearch(SignActivityQueryParam param);


    /**
     * 统计符合条件的活动数量
     * @param param
     * @return
     */
    Integer count4PageSearch(SignActivityQueryParam param);


    /**
     * 更新签到活动状态
     *
     * @param id
     * @param status
     * @return
     */
    Boolean updateStatus(long id, SignActivityStatusEnum status);

    /**
     * 定向开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    Boolean directSwitch(long id, boolean switchOpen) throws BizException;

    /**
     * 黑名单开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    Boolean blackSwitch(long id, boolean switchOpen) throws BizException;

    /**
     * 验证给定ID集合中的有效ID
     * @param actIds
     * @return actIds中有效的ID集合
     */
    List<SignActivitySimpleDto> validActIds(List<Long> actIds);
}
