package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signcontract.SignBetTypeEnum;
import java.io.Serializable;
/**
 * 契约活动期次
 * @author xiaoxuda on 2018/6/6.
 */
public class SignContractIssueDto implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;
    
    /** 
     * 自增主键 
     **/
    private Long id;
    /**
     * 应用ID
     */
    private Long appId;
    /** 
     * 投注活动ID 
     **/
    private Long actId;
    /** 
     * 本期投注总数量 
     **/
    private Long betCount = 0L;
    /** 
     * 本期参与总人数 
     **/
    private Integer buyers = 0;
    /** 
     * 本期获奖人数 
     **/
    private Integer winners = 0;
    /** 
     * 契约周期 
     **/
    private Integer contractCycle;
    /** 
     * 期次开始时间,格式：yyyy-MM-dd 
     **/
    private String startTime;
    /** 
     * 期次结束时间,格式：yyyy-MM-dd 
     **/
    private String endTime;
    /**
     * 免费参与用户数
     */
    private Integer freeUserCount;
    /**
     * 收入支出比
     */
    private Integer rewardRatio;
    /**
     * 投注方式（1：自由额度 2：固定额度 3:多选择额度）
     **/
    private SignBetTypeEnum betType;
    /**
     * 庄家奖励数量
     **/
    private Long bankerBonus;


    public Integer getRewardRatio() {
        return rewardRatio;
    }

    public void setRewardRatio(Integer rewardRatio) {
        this.rewardRatio = rewardRatio;
    }

    public void setId(Long value) {
        this.id = value;
    }
    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setActId(Long value) {
        this.actId = value;
    }
    public Long getActId() {
        return this.actId;
    }
    
    public void setBetCount(Long value) {
        this.betCount = value;
    }
    public Long getBetCount() {
        return this.betCount;
    }
    
    public void setBuyers(Integer value) {
        this.buyers = value;
    }
    public Integer getBuyers() {
        return this.buyers;
    }
    
    public void setWinners(Integer value) {
        this.winners = value;
    }
    public Integer getWinners() {
        return this.winners;
    }
    
    public void setContractCycle(Integer value) {
        this.contractCycle = value;
    }
    public Integer getContractCycle() {
        return this.contractCycle;
    }
    
    public void setStartTime(String value) {
        this.startTime = value;
    }
    public String getStartTime() {
        return this.startTime;
    }
    
    public void setEndTime(String value) {
        this.endTime = value;
    }
    public String getEndTime() {
        return this.endTime;
    }

    public Integer getFreeUserCount() {
        return freeUserCount;
    }

    public void setFreeUserCount(Integer freeUserCount) {
        this.freeUserCount = freeUserCount;
    }

    public SignBetTypeEnum getBetType() {
        return betType;
    }

    public void setBetType(SignBetTypeEnum betType) {
        this.betType = betType;
    }

    public Long getBankerBonus() {
        return bankerBonus;
    }

    public void setBankerBonus(Long bankerBonus) {
        this.bankerBonus = bankerBonus;
    }
}

