package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signpet.PetToyStatusEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ToyTypeEnum;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetPurchasedToyDto implements Serializable{
    private static final long serialVersionUID = -2480305431852203022L;
    /**
     * id
     **/
    private Long id;
    /**
     * 宠物ID
     **/
    private Long petId;
    /**
     * 道具标识
     */
    private String identifier;
    /**
     * 道具名称
     **/
    private String toyName;
    /**
     * 1-状态类 2-装饰类 3-功能类 4-食物类 5-玩具类
     **/
    private ToyTypeEnum toyType;
    /**
     * 使用时是否有状态(0-否，1-是)
     **/
    private Boolean withStatus;
    /**
     * 持续时间(分钟)
     **/
    private Integer duration;
    /**
     * 状态(0-处理中 1-可用 2-已使用)
     **/
    private PetToyStatusEnum toyStatus;
    /**
     * 道具功能描述
     */
    private String description;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * 道具投放资源位序号
     */
    private Integer usePosition;
    /**
     * 道具过期时间
     */
    private Date expireTime;
    /**
     * 是否可重复购买 0-否 1-是
     **/
    private Boolean canRepeatPurchase;
    /**
     * 附加参数存储（个性化）
     **/
    private JSONObject extraJson;
    /**
     * 道具图片
     */
    private String imgUrl;


    public SignPetPurchasedToyDto(){}

    public SignPetPurchasedToyDto(SignPetActivityToyDto petActivityToy){
        this.description = petActivityToy.getDescription();
        this.identifier=petActivityToy.getIdentifier();
        this.toyName=petActivityToy.getToyName();
        this.withStatus=petActivityToy.getWithStatus();
        this.duration=petActivityToy.getDuration();
        this.canRepeatPurchase=petActivityToy.getCanRepeatPurchase();
        this.toyType=petActivityToy.getToyType();
        this.extraJson=petActivityToy.getExtraJson();
        this.imgUrl=petActivityToy.getImgUrl();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPetId() {
        return petId;
    }

    public void setPetId(Long petId) {
        this.petId = petId;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getToyName() {
        return toyName;
    }

    public void setToyName(String toyName) {
        this.toyName = toyName;
    }

    public Boolean getWithStatus() {
        return withStatus;
    }

    public void setWithStatus(Boolean withStatus) {
        this.withStatus = withStatus;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public PetToyStatusEnum getToyStatus() {
        return toyStatus;
    }

    public void setToyStatus(PetToyStatusEnum toyStatus) {
        this.toyStatus = toyStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getUsePosition() {
        return usePosition;
    }

    public void setUsePosition(Integer usePosition) {
        this.usePosition = usePosition;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Boolean getCanRepeatPurchase() {
        return canRepeatPurchase;
    }

    public void setCanRepeatPurchase(Boolean canRepeatPurchase) {
        this.canRepeatPurchase = canRepeatPurchase;
    }

    public ToyTypeEnum getToyType() {
        return toyType;
    }

    public void setToyType(ToyTypeEnum toyType) {
        this.toyType = toyType;
    }

    public JSONObject getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(JSONObject extraJson) {
        this.extraJson = extraJson;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }
}
