package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignWanderActivityDto;
import cn.com.duiba.sign.center.api.dto.SignWanderPetDto;
import cn.com.duiba.sign.center.api.dto.SignWanderRecordDto;
import cn.com.duiba.sign.center.api.dto.WanderRecordStatusDto;
import cn.com.duiba.sign.center.api.enums.signpet.WanderPetRecordTypeEnum;
import cn.com.duiba.sign.center.api.params.ToyPositionUseParam;
import cn.com.duiba.sign.center.api.params.WanderRecordParam;

import java.util.List;

/**
 * Created by Liugq on 2018/8/8.
 * 外来宠物C端接口
 */
@AdvancedFeignClient
public interface RemoteSignWanderMobileService {

    SignWanderActivityDto findById(Long id);

    /**
     * 查询最近的外来宠物到访记录
     * @return
     */
    List<SignWanderRecordDto> selectWanderRecord(WanderRecordParam param);

    /**
     * 根据宠物到访记录
     * @return
     */
    List<SignWanderRecordDto> selectWanderRecordByPet(WanderRecordParam param,WanderPetRecordTypeEnum recordType,String petIdentifier);

    /**
     * 来访动态状态信息:是否有未读&未收取礼物记录
     * @param actId
     * @param consumerId
     * @return
     */
    WanderRecordStatusDto getRecordStatus(Long actId, Long consumerId);

    /**
     * 礼物记录-领取礼物
     * @param recordId 记录主键ID
     */
    void collectGiftRecord(Long recordId);

    /**
     * 查询当前正在来访的宠物
     * @param actId
     * @param consumerId
     * @return
     */
    SignWanderRecordDto findCurrentPet(Long actId,Long consumerId);

    /**
     * 使用道具(外来宠物)
     */
    void useToyForWanderPet(Long actId,Long consumerId,List<ToyPositionUseParam> param) throws BizException;

    /**
     * 查询配置的所有宠物
     * @param actId
     * @return
     */
    List<SignWanderPetDto> selectAllPet(Long actId);

    /**
     * 到访宠物标识列表
     * @param actId
     * @param consumerId
     * @return
     */
    List<String> selectVisitPetIdentifier(Long actId,Long consumerId);

    /**
     * 查询最新一条来访记录
     * @param actId
     * @param consumerId
     * @return
     */
    SignWanderRecordDto getLatestRecord(Long actId,Long consumerId);

    }
