package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignWanderPetDto;

import java.util.List;


/**
 * @author leihu
 * @date created in 2018/6/5
 * @description:
 */
@AdvancedFeignClient
public interface RemoteSignWanderPetService {

    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return
     */
    Long insert(SignWanderPetDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    int delete(Long id);
    /**
     *
     * @param actId
     * @return
     */
    Integer deleteByActId(Long actId);

    /**
     *
     * @param list
     * @return
     */
    Integer batchDelete(List<SignWanderPetDto>list);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    Integer update(SignWanderPetDto dto);
    /**
     *
     * @param list
     * @return
     */
    Integer updateBatch(List<SignWanderPetDto>list);
    /**
     * 批量插入
     */
    Integer batchInsert(List<SignWanderPetDto> list);
    /**
     * 根据主键查询对应数据条目
     * @param id
     * @return
     */
    SignWanderPetDto find(Long id);
    /**
     *
     * @param actId
     * @return
     */
    List<SignWanderPetDto> findByActId(Long actId);

    /**
     *
     * @param actId
     * @return
     */
    List<SignWanderPetDto> findByActIdCache(Long actId);
}
