/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.dto.ExtraSignBonusDto;
import cn.com.duiba.sign.center.api.dto.SignLinkDto;
import cn.com.duiba.sign.center.api.dto.SignRuleDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignCalendarResponseTypeEnum;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignCalendarRuleDto
extends SignRuleDto
implements Serializable {
    private static final long serialVersionUID = 8860667815569018687L;
    public static final String KEY_EXTRA_BONUS = "extraBonus";
    private static final Logger logger = LoggerFactory.getLogger(SignCalendarRuleDto.class);
    private String signDate;
    private Boolean iconCustom;
    private String iconImage;
    private SignCalendarResponseTypeEnum responseType;
    private String prompt;
    private String skipUrl;
    private String html;
    private List<SignLinkDto> linkGroup;
    private Date gmtCreate;
    private Date gmtModified;
    private JSONObject extJson;

    public String getSignDate() {
        return this.signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public Boolean getIconCustom() {
        return this.iconCustom;
    }

    public void setIconCustom(Boolean iconCustom) {
        this.iconCustom = iconCustom;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public void setIconImage(String iconImage) {
        this.iconImage = iconImage;
    }

    public SignCalendarResponseTypeEnum getResponseType() {
        return this.responseType;
    }

    public void setResponseType(SignCalendarResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getSkipUrl() {
        return this.skipUrl;
    }

    public void setSkipUrl(String skipUrl) {
        this.skipUrl = skipUrl;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<SignLinkDto> getLinkGroup() {
        return this.linkGroup;
    }

    public void setLinkGroup(List<SignLinkDto> linkGroup) {
        this.linkGroup = linkGroup;
    }

    public static List<SignLinkDto> getLinkGroupList(String links) {
        ArrayList linkGroup = Lists.newArrayList();
        if (StringUtils.isBlank((String)links)) {
            return linkGroup;
        }
        try {
            return JSONArray.parseArray((String)links, SignLinkDto.class);
        }
        catch (Exception e) {
            logger.warn("\u8f6c\u5316SignLinkDto list\u51fa\u9519", (Throwable)e);
            return linkGroup;
        }
    }

    public static String transferToLinkGroupArray(List<SignLinkDto> links) {
        JSONArray linksArray = new JSONArray();
        if (links == null) {
            return linksArray.toString();
        }
        return JSONArray.toJSONString(links);
    }

    public JSONObject getExtJson() {
        return this.extJson;
    }

    public void setExtJson(JSONObject extJson) {
        this.extJson = extJson;
    }

    public void putToExtra(String key, Object val) {
        if (this.extJson == null) {
            this.extJson = new JSONObject();
        }
        this.extJson.put(key, val);
    }

    public void removeFromExtra(String key) {
        if (this.extJson == null) {
            return;
        }
        this.extJson.remove((Object)key);
    }

    public Object getFromExtra(String key) {
        if (this.extJson == null) {
            return null;
        }
        return this.extJson.get((Object)key);
    }

    public ExtraSignBonusDto getExtraSignBonus() {
        if (this.extJson == null) {
            return null;
        }
        return (ExtraSignBonusDto)this.extJson.getObject(KEY_EXTRA_BONUS, ExtraSignBonusDto.class);
    }

    public boolean isOpenExtraBonus() {
        ExtraSignBonusDto extraSignBonusDto = this.getExtraSignBonus();
        if (extraSignBonusDto == null || extraSignBonusDto.getOpenStatus() == null) {
            return false;
        }
        return extraSignBonusDto.getOpenStatus();
    }
}

