package cn.com.duiba.sign.center.api.enums.signpet;

/**
 * Created by fangdong on 2018/11/06
 */
public enum SignPetTravelRecordStatusEnum {

    FAILURE(0, "失败"),
    CREATION(1, "已创建"),
    SUCCESS(2, "成功"),
    ;

    private Integer type;
    private String desc;

    SignPetTravelRecordStatusEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }


    public static SignPetTravelRecordStatusEnum getByType(Integer type) {
        for (SignPetTravelRecordStatusEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
