package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignActivitySkinStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public class SignActivitySkinDto implements Serializable {
    private static final long serialVersionUID = -6131778697519478029L;

    public static final Integer AppDirectSwitch = 1;
    public static final Integer DeveloperBlackSwitch = 2;

    public static final String IDENTIFIER_PREFIX_CIRCLE_TYPE = "cirType_";
    public static final String IDENTIFIER_PREFIX_RW_TYPE = "rwType_";
    public static final String IDENTIFIER_RESIGN_OPEN = "resignOpen";

    public static final String EXTRA_CONTRACT_CYCLE_LIMIT = "contractCycleLimit";

    private Long id;
    /**
     * 皮肤名称
     */
    private String title;
    /**
     * 签到类型
     */
    private SignActivityTypeEnum signType;
    /**
     * 皮肤代码
     */
    private String html;
    /**
     * 预览图
     */
    private String previewImage;
    /**
     * 皮肤状态
     */
    private SignActivitySkinStatusEnum status;
    /**
     * 功能开关
     */
    private Integer switches;
    /**
     * 删除标记
     */
    private Boolean deleted;
    /**
     * 是否开放给开发者编辑
     */
    private Boolean openToDev;
    /**
     * 不同标识逗号分隔，用于匹配适用的签到活动
     */
    private String identifier;
    /**
     * 签到模块背景图
     */
    private String bgImg;

    /**
     * 模板标识
     */
    private Long templateId;

    /**
     * 样式
     */
    private String css;

    /**
     * 签到皮肤预览时绑定的签到活动id
     */
    private Long previewActivityId;
    /**
     * 附加订制信息
     */
    private JSONObject extra;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SignActivityTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignActivityTypeEnum signType) {
        this.signType = signType;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getPreviewImage() {
        return previewImage;
    }

    public void setPreviewImage(String previewImage) {
        this.previewImage = previewImage;
    }

    public SignActivitySkinStatusEnum getStatus() {
        return status;
    }

    public void setStatus(SignActivitySkinStatusEnum status) {
        this.status = status;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getOpenToDev() {
        return openToDev;
    }

    public void setOpenToDev(Boolean openToDev) {
        this.openToDev = openToDev;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getBgImg() {
        return bgImg;
    }

    public void setBgImg(String bgImg) {
        this.bgImg = bgImg;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getCss() {
        return css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public Long getPreviewActivityId() {
        return previewActivityId;
    }

    public void setPreviewActivityId(Long previewActivityId) {
        this.previewActivityId = previewActivityId;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    /**
     * 验证是否可用于给定活动
     * @param activity
     * @return
     */
    public boolean actAdaptationValid(SignActivityDto activity){
        //兑吧定向的皮肤，通用适配,目的是为了兼容现有逻辑
        if(!Boolean.TRUE.equals(this.openToDev)){
            return true;
        }
        if(this.identifier == null){
            return false;
        }
        SignRuleConfigDto signConfig = activity.getSignRuleConfig();
        ReSignRuleConfigDto reSignConfig = activity.getReSignRuleConfig();
        SignRewardConfigDto rwConfig = activity.getSignRewardConfig();
        //签到周期类型验证,前缀加上类型名称
        String typeKey = IDENTIFIER_PREFIX_CIRCLE_TYPE + signConfig.getType().name();
        if(!this.identifier.contains(typeKey)){
            return false;
        }
        //奖励类型验证，前缀加上类型名称
        for(SignRewardRuleDto rw : rwConfig.getRwRules().values()){
            typeKey = IDENTIFIER_PREFIX_RW_TYPE + rw.getRwType().name();
            if(rw.getOpen() && !this.identifier.contains(typeKey)){
                return false;
            }
        }
        //补签验证
        if(reSignConfig.getOpen() && !this.identifier.contains(IDENTIFIER_RESIGN_OPEN)){
            return false;
        }
        return true;
    }
}
