package cn.com.duiba.sign.center.api.remoteservice.signcontract;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.ContractDaySignDto;
import cn.com.duiba.sign.center.api.dto.ContractRankDto;
import cn.com.duiba.sign.center.api.dto.ContractRewardRecordDto;
import cn.com.duiba.sign.center.api.dto.SignAmpifyCardDto;
import cn.com.duiba.sign.center.api.dto.SignContractBetDto;
import cn.com.duiba.sign.center.api.dto.SignContractIssueDto;
import cn.com.duiba.sign.center.api.dto.SignContractJoinStaticsDto;
import cn.com.duiba.sign.center.api.dto.SignContractLogDto;
import cn.com.duiba.sign.center.api.dto.SignContractUserStaticsDto;
import cn.com.duiba.sign.center.api.enums.signcontract.ContractRankTypeEnum;
import cn.com.duiba.sign.center.api.params.AmpifyCardQueryParam;
import cn.com.duiba.sign.center.api.params.IssueDateUpdateParam;
import cn.com.duiba.sign.center.api.params.SignContractBetUKParam;
import cn.com.duiba.sign.center.api.params.SignContractBetUpdateParam;
import cn.com.duiba.sign.center.api.params.SignContractGetWardParam;
import cn.com.duiba.sign.center.api.params.SignContractIssueUKParam;
import cn.com.duiba.sign.center.api.params.SignContractIssueUpdateParam;
import cn.com.duiba.sign.center.api.params.SignContractJoinParam;
import cn.com.duiba.sign.center.api.params.SignContractLogUKParam;
import cn.com.duiba.sign.center.api.params.SignContractSignParam;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoxuda on 2018/6/6.
 */
@AdvancedFeignClient
public interface RemoteSignContractMobileService {

    /**
     * 查询最近的一次期次信息
     * @return
     */
    SignContractIssueDto findLastIssue(Long appId, Long actId);

    List<SignAmpifyCardDto> selectCardByUser(AmpifyCardQueryParam param);

    /**
     * 根据id修改参与信息
     *
     * @param param
     * @return
     */
    Boolean updateBetById(SignContractBetUpdateParam param);

    /**
     * 通过唯一键查询打卡情况
     * @return
     */
    SignContractLogDto findByUK(SignContractLogUKParam param);

    /**
     * 查询期次打卡信息（成功打卡人数&收益倍率）
     *
     * @param issueId
     * @param isEnd : 是否查询最后一天数据
     * @return
     */
    ContractDaySignDto issueSignInfo(Long issueId,Boolean isEnd);

    /**
     * 查询最近的一次参与记录
     * @param param
     * @return
     */
    SignContractBetDto findLastBet(SignContractBetUKParam param);
    /**
     * 查询给定活动下未完成的契约
     * @param param
     * @return
     */
    SignContractBetDto findUndoneBet(SignContractBetUKParam param);

    /**
     * 查询期次信息
     * @return
     */
    SignContractIssueDto findIssueById(Long issueId);

    /**
     * 批量查询期次信息
     * @param issueIds
     * @return
     */
    List<SignContractIssueDto> findIssueByIds(List<Long> issueIds);

    /**
     * 查询所有参与记录
     * @param param
     * @return
     */
    List<SignContractBetDto> findJoinedByAct(SignContractBetUKParam param);

    /**
     * 分页查询参与记录,参与时间倒序
     * @param param
     * @return
     */
    List<SignContractBetDto> pageFindJoinedByAct(SignContractBetUKParam param);

    /**
     * 统计所有参与的期次数量
     * @param param
     * @return
     */
    Integer countJoinedByAct(SignContractBetUKParam param);

    /**
     * 查询已完成待领奖的契约个数
     * @param param
     * @return
     */
    Integer countNotGetReward(SignContractBetUKParam param);

    /**
     * 查询已完成待领奖的契约
     *
     * @param param
     * @return
     */
    List<SignContractBetDto> findDoneBet(SignContractBetUKParam param);


    /**
     * 参与契约, 如果有未完成契约且契约已过期或已中断不可补救，则直接将此类契约置为失败，之后再新建契约
     * @param param
     * @return
     */
    SignContractBetDto joinContract(SignContractJoinParam param) throws BizException;

    /**
     * 打卡
     * @return 打卡记录ID
     * @exception
     */
    Long doSign(SignContractSignParam param) throws BizException;

    /**
     * 领奖
     * @param param
     * @return
     */
    Boolean getReward(SignContractGetWardParam param) throws BizException;

    /**
     * 查询给定活动下今日可参加的期次
     * @param actId
     * @return
     */
    SignContractIssueDto getTodayIssue(Long actId, Long appId);

    /**
     * 根据契约ID查询
     * @param betId
     * @return
     */
    SignContractBetDto findContractBetById(Long betId);

    /**
     * 统计契约活动的历史累积参与数据
     * @param actId
     * @return
     */
    SignContractJoinStaticsDto countContractBetUser(Long appId, Long actId);

    /**
     * 今日开奖的获奖名单
     * @param issueId
     * @return 获奖用户ID
     */
    List<ContractRewardRecordDto> selectRewardRecordByIssue(Long issueId, Integer showNum);

    /**
     * 根据唯一键查询期次信息
     * @param param
     * @return
     */
    SignContractIssueDto findIssueByUK(SignContractIssueUKParam param);

    /**
     * 查询契约签到活动获利排行榜
     * @param contractId
     * @param topNum
     * @return
     */
    List<ContractRankDto> getRewardRankTop(Long contractId, Long appId, ContractRankTypeEnum type, Integer topNum);

    /**
     * 查询上一期回报率
     *
     * @param actId
     * @param appId
     * @return
     */
    Integer getLastIssueRewardRatio(Long actId, Long appId);

    /**
     * 用户参与信息统计
     * @param param
     * @return
     */
    SignContractUserStaticsDto staticsUserBetInfo(SignContractBetUKParam param);

    /**
     * 查询用户首次参与日期
     * @param actId
     * @param consumerId
     * @return
     */
    Date queryFirstJoinDate(Long actId,Long consumerId);

    /**
     * 后台修改数据方法（慎用）
     * @param param
     * @return
     */
    Boolean backUpdateBet(SignContractBetUpdateParam param);
    /**
     * 修改期次数据
     * @param param
     * @return
     */
    Boolean backendUpdateIssue(IssueDateUpdateParam param);
}
