package cn.com.duiba.sign.center.api.enums.signremind;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by fangdong on 2018/10/15
 */
public enum SignRemindConfigCodeEnum {

    SOUGOU_READ_SIGN_CONTRACT("sougou_read@sign_contract", "搜狗阅读契约签到"),
    WAHAHA_SIGN("wahaha_read@sign_calendar", "哇哈哈日历签到"),
    ZHUANZHUAN_SIGN("zhuanzhuan@sign_calendar", "转转小游戏日历签到")
    ;

    private String code;
    private String desc;
    private static Map<String, SignRemindConfigCodeEnum> valueMap = new HashMap<>();
    static {

        for (SignRemindConfigCodeEnum value : values()){
            valueMap.put(value.getCode(), value);
        }

    }

    SignRemindConfigCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignRemindConfigCodeEnum getByCode(String code){
        SignRemindConfigCodeEnum type = valueMap.get(code);
        if(type == null){
            throw new SignCenterException("不支持的签到提醒配置code");
        }
        return type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
