package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignSkinTypeEnum;
import cn.com.duiba.sign.center.api.enums.signcontract.OpenTypeEnum;
import cn.com.duiba.sign.center.api.enums.signcontract.RankPeriodEnum;
import cn.com.duiba.sign.center.api.enums.signcontract.SignBetTypeEnum;
import cn.com.duiba.sign.center.api.enums.signcontract.SignContractBonusTypeEnum;

import java.io.Serializable;
import java.util.Date;
/**
 * @author xiaoxuda on 2018/6/6.
 */
public class SignContractDto implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;

    /**
     * 自增主键 
     **/
    private Long id;
    /**
     * 活动名称 
     **/
    private String title;
    /**
     * 投注方式（1：自由额度 2：固定额度 3:多选择额度）
     **/
    private SignBetTypeEnum betType;
    /**
     * 投注数量（固定额度时有效）
     **/
    private Long betCount;
    /**
     * 庄家奖励数量
     **/
    private Long bankerBonus;
    /**
     * 规则描述
     **/
    private String ruleDesc;
    /**
     * 契约周期
     **/
    private Integer contractCycle;
    /**
     * 参与时间限制，0：无限制，1：有限制
     **/
    private Boolean joinTimeLimit;
    /**
     * 打卡限制起始时间，HH:mm
     **/
    private String joinTimeStart;
    /**
     * 打卡限制最晚时间，HH:mm
     **/
    private String joinTimeEnd;
    /**
     * 开启开关，0：关闭，1：打开
     **/
    private Boolean openStatus;
    /**
     * 删除标记：0-否 1-是
     */
    private Boolean deleted;
    /**
     * 梯度押注金额
     */
    private String gradientAmountList;
    /**
     * 参与截止时间
     */
    private Date joinDeadLine;
    /**
     * 每天免费参与用户数
     */
    private Integer freeJoinLimit;

    private RankPeriodEnum rankPeriod;
    /**
     * 瓜分类型,0:瓜分积分,1:瓜分现金
     */
    private SignContractBonusTypeEnum bonusType;
    /**
     * 用户造假率(扩大了100倍的值)
     */
    private Integer fakeRatio;
    /**
     * 作假临界率(扩大了100倍的值)
     */
    private Integer mockValue;

    /**
     * 开奖类型 0-倍率 1-随机
     * @return
     */
    private OpenTypeEnum openType;
    /**
     * 是否可使用加倍卡
     */
    private Boolean enableAmpifyCard;

    /**
     * 皮肤类型 0-自定义 1-模板
     */
    private SignSkinTypeEnum skinType;
    /**
     * 皮肤ID
     */
    private Long skinId;

    public Integer getMockValue() {
        return mockValue;
    }

    public void setMockValue(Integer mockValue) {
        this.mockValue = mockValue;
    }

    public SignContractBonusTypeEnum getBonusType() {
        return bonusType;
    }

    public void setBonusType(SignContractBonusTypeEnum bonusType) {
        this.bonusType = bonusType;
    }

    public Integer getFakeRatio() {
        return fakeRatio;
    }

    public void setFakeRatio(Integer fakeRatio) {
        this.fakeRatio = fakeRatio;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SignBetTypeEnum getBetType() {
        return betType;
    }

    public void setBetType(SignBetTypeEnum betType) {
        this.betType = betType;
    }

    public Long getBetCount() {
        return betCount;
    }

    public void setBetCount(Long betCount) {
        this.betCount = betCount;
    }

    public Long getBankerBonus() {
        return bankerBonus;
    }

    public void setBankerBonus(Long bankerBonus) {
        this.bankerBonus = bankerBonus;
    }

    public String getRuleDesc() {
        return ruleDesc;
    }

    public void setRuleDesc(String ruleDesc) {
        this.ruleDesc = ruleDesc;
    }

    public Integer getContractCycle() {
        return contractCycle;
    }

    public void setContractCycle(Integer contractCycle) {
        this.contractCycle = contractCycle;
    }

    public Boolean getJoinTimeLimit() {
        return joinTimeLimit;
    }

    public void setJoinTimeLimit(Boolean joinTimeLimit) {
        this.joinTimeLimit = joinTimeLimit;
    }

    public String getJoinTimeStart() {
        return joinTimeStart;
    }

    public void setJoinTimeStart(String joinTimeStart) {
        this.joinTimeStart = joinTimeStart;
    }

    public String getJoinTimeEnd() {
        return joinTimeEnd;
    }

    public void setJoinTimeEnd(String joinTimeEnd) {
        this.joinTimeEnd = joinTimeEnd;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getGradientAmountList() {
        return gradientAmountList;
    }

    public void setGradientAmountList(String gradientAmountList) {
        this.gradientAmountList = gradientAmountList;
    }

    public Date getJoinDeadLine() {
        return joinDeadLine;
    }

    public void setJoinDeadLine(Date joinDeadLine) {
        this.joinDeadLine = joinDeadLine;
    }

    public Integer getFreeJoinLimit() {
        return freeJoinLimit;
    }

    public void setFreeJoinLimit(Integer freeJoinLimit) {
        this.freeJoinLimit = freeJoinLimit;
    }

    public RankPeriodEnum getRankPeriod() {
        return rankPeriod;
    }

    public void setRankPeriod(RankPeriodEnum rankPeriod) {
        this.rankPeriod = rankPeriod;
    }

    public OpenTypeEnum getOpenType() {
        return openType;
    }

    public void setOpenType(OpenTypeEnum openType) {
        this.openType = openType;
    }

    public Boolean getEnableAmpifyCard() {
        return enableAmpifyCard;
    }

    public void setEnableAmpifyCard(Boolean enableAmpifyCard) {
        this.enableAmpifyCard = enableAmpifyCard;
    }

    public SignSkinTypeEnum getSkinType() {
        return skinType;
    }

    public void setSkinType(SignSkinTypeEnum skinType) {
        this.skinType = skinType;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }
}

