package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.dto.signfornew.SignForNewDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignRewardTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;

import java.io.Serializable;

/**
 * Created by xiaoxuda on 2017/12/18.
 */
public class SignActivityConfigDto implements Serializable {
    private static final long serialVersionUID = -4133020840880440355L;

    private SignActivityTypeEnum signType;
    private Long signActId;
    private String title;
    private String description;
    private SignRuleConfigDto signRule;
    private SignRewardConfigDto signReward;
    private ReSignRuleConfigDto reSignRuleConfig;
    private SignRewardRule4SpecDayDto signRewardRule4SpecDay;

    public SignActivityConfigDto(){}

    public SignActivityConfigDto(SignActivityDto signActivity, SignOperatingDto signOperating){
        this.signType = signOperating.getSignType();
        this.signActId = signActivity.getId();
        if(signOperating.getFromExtra(SignActivityDto.KEY_SIGNRULE) != null){
            title = (String)signOperating.getFromExtra(SignOperatingDto.KEY_TITLE);
            description = (String)signOperating.getFromExtra(SignOperatingDto.KEY_DESCRIPTION);
            signRule = signOperating.getSignRuleConfig();
            signReward = signOperating.getSignRewardConfig();
            reSignRuleConfig = signOperating.getReSignRuleConfig();
        }else{
            title = signActivity.getTitle();
            description = signActivity.getDescription();
            signRule = signActivity.getSignRuleConfig();
            signReward = signActivity.getSignRewardConfig();
            reSignRuleConfig = signActivity.getReSignRuleConfig();
        }
        signRewardRule4SpecDay = signOperating.getSignRewardRule4SpecDay();
    }

    public SignActivityConfigDto(SignForNewDto signForNew, SignOperatingDto signOperating){
        this.signType = signOperating.getSignType();
        this.signActId = signForNew.getId();

        title = signForNew.getTitle();
        description = signForNew.getIntro();
        signRule = new SignRuleConfigDto();
        signRule.setType(SignTypeEnum.CIRCLE);
        signReward = new SignRewardConfigDto();
        SignRewardRuleDto signRewardRule = new SignRewardRuleDto();
        signRewardRule.setRwType(SignRewardTypeEnum.CIRCLE);
        signRewardRule.setOpen(true);
        signRewardRule.setItems(signForNew.getRewardRule());
        signReward.putToRwRules(signRewardRule);

        reSignRuleConfig = new ReSignRuleConfigDto();
        signRewardRule4SpecDay = signOperating.getSignRewardRule4SpecDay();
    }

    public Long getSignActId() {
        return signActId;
    }

    public void setSignActId(Long signActId) {
        this.signActId = signActId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SignRuleConfigDto getSignRule() {
        return signRule;
    }

    public void setSignRule(SignRuleConfigDto signRule) {
        this.signRule = signRule;
    }

    public SignRewardConfigDto getSignReward() {
        return signReward;
    }

    public void setSignReward(SignRewardConfigDto signReward) {
        this.signReward = signReward;
    }

    public ReSignRuleConfigDto getReSignRuleConfig() {
        return reSignRuleConfig;
    }

    public void setReSignRuleConfig(ReSignRuleConfigDto reSignRuleConfig) {
        this.reSignRuleConfig = reSignRuleConfig;
    }

    public SignRewardRule4SpecDayDto getSignRewardRule4SpecDay () {
        return signRewardRule4SpecDay;
    }

    public void setSignRewardRule4SpecDay (SignRewardRule4SpecDayDto signRewardRule4SpecDay) {
        this.signRewardRule4SpecDay = signRewardRule4SpecDay;
    }

    public SignActivityTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignActivityTypeEnum signType) {
        this.signType = signType;
    }
}
