package cn.com.duiba.sign.center.api.util;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignSourceTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/3/18.
 */
public class SignActTypeUtil {
    private static Map<SignSourceTypeEnum, SignActivityTypeEnum> sourceToActType = new HashMap<>();
    private static Map<SignActivityTypeEnum, SignSourceTypeEnum> actTypeToSource = new HashMap<>();
    private static Map<SignActivityTypeEnum, ActivityUniformityTypeEnum> actTypeToUniform = new HashMap<>();
    static{
        sourceToActType.put(SignSourceTypeEnum.SIGN_SYSTEM, SignActivityTypeEnum.SIGN_CALENDAR);
        sourceToActType.put(SignSourceTypeEnum.SIGN_FOR_NEW, SignActivityTypeEnum.SIGN_FOR_NEW);
        for(Map.Entry<SignSourceTypeEnum, SignActivityTypeEnum> entry : sourceToActType.entrySet()){
            actTypeToSource.put(entry.getValue(), entry.getKey());
        }

        actTypeToUniform.put(SignActivityTypeEnum.SIGN_CALENDAR, ActivityUniformityTypeEnum.CalendarSign);
        actTypeToUniform.put(SignActivityTypeEnum.SIGN_CONTRACT, ActivityUniformityTypeEnum.ContractSign);
        actTypeToUniform.put(SignActivityTypeEnum.SIGN_FOR_NEW, ActivityUniformityTypeEnum.SignForNew);
    }

    public static SignActivityTypeEnum getSignActType(SignSourceTypeEnum sourceType){
        return sourceToActType.get(sourceType);
    }

    public static SignSourceTypeEnum getSignSource(SignActivityTypeEnum signType){
        return actTypeToSource.get(signType);
    }
}
