package cn.com.duiba.sign.center.api.enums.signtreasure;

/**
 * @Author chenxiangge
 * @Date 2019/4/28
 */
public enum SignTreasureActStatusEnum {
    NOT_START(-1, "未开始"),
    PROCESS(0, "进行中"),
    FINISHED(1, "已结束"),
    ;

    private Integer code;
    private String desc;

    SignTreasureActStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignTreasureActStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SignTreasureActStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }


    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
