package cn.com.duiba.sign.center.api.remoteservice.signtreasure;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signtreasure.SignTreasureSignInfoDto;
import cn.com.duiba.sign.center.api.dto.signtreasure.SignTreasureUserRecordDto;
import cn.com.duiba.sign.center.api.dto.signtreasure.TreasureCodeExchangeParam;
import cn.com.duiba.sign.center.api.dto.signtreasure.TreasureCodeExchangeResultParam;
import cn.com.duiba.sign.center.api.params.SignRequestParam;


@AdvancedFeignClient
public interface RemoteSignTreasureUserRecordService {

    /**
     * 夺宝签到
     * @param signRequestParam
     * @param phaseId
     * @return
     * @throws BizException
     */
    Long dosign(SignRequestParam signRequestParam, Long phaseId) throws BizException;

    /**
     * 查询用户签到信息
     * @param phaseId
     * @param consumerId
     * @return
     */
    SignTreasureSignInfoDto querySignInfo(Long phaseId, Long consumerId);

    /**
     * 夺宝码积分兑换
     * @param param
     * @return
     */
    TreasureCodeExchangeResultParam exchangeTreasureCode(TreasureCodeExchangeParam param);

    /**
     * 用户参与记录
     * @param actId
     * @param consumerId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<SignTreasureUserRecordDto> selectUserHistory(Long actId, Long consumerId, Integer pageNo, Integer pageSize);

}
