package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignActionEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignSourceTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by liuyao on 2016/12/21.
 * 签到日志表
 */
public class SignLogDto extends BaseDto implements Serializable{

    public static final long serialVersionUID = 1053047858801268831L;

    /**
     * 积分及抽奖次数备注信息
     */
    public static final String REMARK_MSG_KEY = "msg";
    /**
     * 备注信息中的奖励信息，value结构 :[{SignRewardType.code : val}]
     */
    public static final String REWARD_KEY = "rw";

    private Long id;
    /**
     * 签到流水号
     */
    private Long logId;
    /**
     * 开发者业务号（来至开发者可为空）
     */
    private String bizId;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * appID
     */
    private Long appId;
    /**
     * 签到数据来源
     */
    private SignSourceTypeEnum sourceType;
    /**
     * 签到来源关联ID
     */
    private Long sourceRelationId;
    /**
     * 本次签到所加积分
     */
    private Integer credits;
    /**
     * 本次签到所加活动次数
     */
    private Integer activityCount;
    /**
     * 签到类型
     */
    private SignTypeEnum signType;
    /**
     * 签到状态
     */
    private SignStatusEnum signStatus;

    /**
     * 增加活动次数备注
     */
    private String activityCountRemark;
    /**
     * json格式备注
     */
    private JSONObject countRemarkJson = new JSONObject();
    /**
     * 增加活动次数状态
     */
    private SignActionEnum activityCountStatus;
    /**
     * 增加积分备注
     */
    private String creditsRemark;
    /**
     * json格式备注
     */
    private JSONObject creditsRemarkJson = new JSONObject();
    /**
     * 增加积分状态
     */
    private SignActionEnum creditsStatus;
    /**
     * 签到发起时间
     */
    private Date signDate;
    /**
     * 是否是补签
     */
    private Boolean reSign;
    /**
     * 签到结果信息,失败时：失败原因，成功时：奖励配置JSONObject.toJSONString(RewardResult)
     */
    private String signRemark;

    private Date gmtCreate;
    private Date gmtModified;

    public RewardResult parseSignRemark(){
        if(StringUtils.isBlank(signRemark) || !signRemark.startsWith("{") || !signRemark.endsWith("}")){
            return new RewardResult();
        }
        try{
            return JSONObject.parseObject(signRemark, RewardResult.class);
        } catch (Exception e){
            return new RewardResult();
        }

    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getLogId() {
        return logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SignSourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SignSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public SignStatusEnum getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(SignStatusEnum signStatus) {
        this.signStatus = signStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getActivityCountRemark() {
        return activityCountRemark;
    }

    public void setActivityCountRemark(String activityCountRemark) {
        this.activityCountRemark = activityCountRemark;
    }

    public SignActionEnum getActivityCountStatus() {
        return activityCountStatus;
    }

    public void setActivityCountStatus(SignActionEnum activityCountStatus) {
        this.activityCountStatus = activityCountStatus;
    }

    public String getCreditsRemark() {
        return creditsRemark;
    }

    public void setCreditsRemark(String creditsRemark) {
        this.creditsRemark = creditsRemark;
    }

    public SignActionEnum getCreditsStatus() {
        return creditsStatus;
    }

    public void setCreditsStatus(SignActionEnum creditsStatus) {
        this.creditsStatus = creditsStatus;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Boolean getReSign() {
        return reSign;
    }

    public void setReSign(Boolean reSign) {
        this.reSign = reSign;
    }

    public String getSignRemark() {
        return signRemark;
    }

    public void setSignRemark(String signRemark) {
        this.signRemark = signRemark;
    }

    public JSONObject getCountRemarkJson() {
        return countRemarkJson;
    }

    public void setCountRemarkJson(JSONObject countRemarkJson) {
        this.countRemarkJson = countRemarkJson;
    }

    public JSONObject getCreditsRemarkJson() {
        return creditsRemarkJson;
    }

    public void setCreditsRemarkJson(JSONObject creditsRemarkJson) {
        this.creditsRemarkJson = creditsRemarkJson;
    }

    public void put2CreditsRemark(String key, Object obj){
        this.creditsRemarkJson.put(key, obj);
        this.creditsRemark = this.creditsRemarkJson.toJSONString();
    }

    public void put2CountRemark(String key, Object obj){
        this.countRemarkJson.put(key, obj);
        this.activityCountRemark = this.countRemarkJson.toJSONString();
    }

}
