package cn.com.duiba.sign.center.api.remoteservice.signtreasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signtreasure.SignTreasureCodeDetailDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteSignTreasureCodeDetailService {

    /**
     * 查询用户期次所有的夺宝码
     * @param phaseId
     * @param consumerId
     * @return
     */
    List<String> selectUserCodesByPhase(Long phaseId,Long consumerId);

    /**
     * 查询多个期次下用户的夺宝码明细数据
     * @param phaseIds
     * @param consumerId
     * @return
     */
    List<SignTreasureCodeDetailDto> selectUserCodeByPhaseIds(List<Long> phaseIds, Long consumerId);

    /**
     * 根据业务id查询夺宝码
     * @param consumerId
     * @param bizId
     * @return
     */
    List<SignTreasureCodeDetailDto> selectCodeByBizId(Long consumerId, String bizId);

    /**
     * 积分兑换夺宝码-积分扣减回调后处理
     * @param bizId
     */
    boolean dealAfterCreditsSub(String bizId, boolean result);

    /**
     * 用户待领奖记录
     * @param actId
     * @param consumerId
     * @return
     */
    SignTreasureCodeDetailDto findWaitRewardRecord(Long actId, Long consumerId);

    void doTakePrize(Long  detailId);

    SignTreasureCodeDetailDto find(Long detailId);

}
