package cn.com.duiba.sign.center.api.dto.signtreasure;

import cn.com.duiba.sign.center.api.enums.signtreasure.RewardStatusEnum;
import java.io.Serializable;

/**
 * @author liugq
 * @date created in 2019.5.5
 * @description: 
 */
public class SignWinRecordDto implements Serializable {

    private static final long serialVersionUID = -5147624735687684334L;
    /**
     * 主键id 
     **/
    private Long id;
    /** 
     * 应用id 
     **/
    private Long appId;
    /** 
     * 兑吧用户id 
     **/
    private Long consumerId;
    /** 
     * 开发者用户id 
     **/
    private String partnerUserId;
    /** 
     * 活动id 
     **/
    private Long actId;
    /** 
     * 统一活动类型，见ActivityUniformityTypeEnum枚举 
     **/
    private Integer actType;
    /** 
     * 获奖等级 
     **/
    private Integer prizeLevel;
    /** 
     * 期次id 
     **/
    private Long phaseId;
    /**
     * 期次号（期次开始时间的年月日格式）
     */
    private String phaseNumber;
    /** 
     * 奖项id 
     **/
    private Long optionId;
    /** 
     * 奖项类型object:实物;phonebill:话费;qb:Q币;coupon:优惠券;alipay:支付宝;virtual:虚拟商品 
     **/
    private String optionType;
    /** 
     * 奖项名称 
     **/
    private String optionName;
    /** 
     * 奖项图片url 
     **/
    private String optionLogo;
    /**
     * 状态: 1-待领奖 2-已领奖
     **/
    private RewardStatusEnum rewardStatus;


    public void setId(Long value) {
        this.id = value;
    }
    public Long getId() {
        return this.id;
    }
    
    public void setAppId(Long value) {
        this.appId = value;
    }
    public Long getAppId() {
        return this.appId;
    }
    
    public void setConsumerId(Long value) {
        this.consumerId = value;
    }
    public Long getConsumerId() {
        return this.consumerId;
    }
    
    public void setPartnerUserId(String value) {
        this.partnerUserId = value;
    }
    public String getPartnerUserId() {
        return this.partnerUserId;
    }
    
    public void setActId(Long value) {
        this.actId = value;
    }
    public Long getActId() {
        return this.actId;
    }
    
    public void setActType(Integer value) {
        this.actType = value;
    }
    public Integer getActType() {
        return this.actType;
    }
    
    public void setPrizeLevel(Integer value) {
        this.prizeLevel = value;
    }
    public Integer getPrizeLevel() {
        return this.prizeLevel;
    }
    
    public void setPhaseId(Long value) {
        this.phaseId = value;
    }
    public Long getPhaseId() {
        return this.phaseId;
    }

    public String getPhaseNumber() {
        return phaseNumber;
    }

    public void setPhaseNumber(String phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public void setOptionId(Long value) {
        this.optionId = value;
    }
    public Long getOptionId() {
        return this.optionId;
    }
    
    public void setOptionType(String value) {
        this.optionType = value;
    }
    public String getOptionType() {
        return this.optionType;
    }
    
    public void setOptionName(String value) {
        this.optionName = value;
    }
    public String getOptionName() {
        return this.optionName;
    }
    
    public void setOptionLogo(String value) {
        this.optionLogo = value;
    }
    public String getOptionLogo() {
        return this.optionLogo;
    }

    public RewardStatusEnum getRewardStatus() {
        return rewardStatus;
    }

    public void setRewardStatus(RewardStatusEnum rewardStatus) {
        this.rewardStatus = rewardStatus;
    }
}

