package cn.com.duiba.sign.center.api.enums.signtreasure;

/**
 * @Author chenxiangge
 * @Date 2019/4/28
 */
public enum SignTreasurePhaseStatusEnum {
    PROCESS(1, "进行中"),
    WAIT_OPEN_PRIZE(2, "待开奖"),
    OPEN_PRIZE(3, "已开奖"),
    ;

    private Integer code;
    private String desc;

    SignTreasurePhaseStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignTreasurePhaseStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SignTreasurePhaseStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
