package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignRewardTypeEnum;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 签到奖励配置
 * Created by xiaoxuda on 2017/11/14.
 */
public class SignRewardConfigDto implements Serializable {
    private static final long serialVersionUID = 7457954542173827278L;

    /**
     * 规则集合
     */
    private Map<SignRewardTypeEnum, SignRewardRuleDto> rwRules = new HashMap<>();

    public void putToRwRules(SignRewardRuleDto reward){
        if(rwRules == null){
            rwRules = new HashMap<>();
        }
        rwRules.put(reward.getRwType(), reward);
    }

    public Map<SignRewardTypeEnum, SignRewardRuleDto> getRwRules() {
        return rwRules;
    }

    public void setRwRules(Map<SignRewardTypeEnum, SignRewardRuleDto> rwRules) {
        this.rwRules = rwRules;
    }
}
