package cn.com.duiba.sign.center.api.params;


import cn.com.duiba.sign.center.api.enums.creditssign.SignSourceTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xiaoxuda on 2017/12/29.
 */
public class SignStaticsQueryParam implements Serializable {
    private static final long serialVersionUID = -4205702866227875854L;
    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * app id
     */
    private Long appId;

    /**
     * 签到来源
     */
    private SignSourceTypeEnum sourceType;

    /**
     * 签到来源关联ID,签到关联活动时必填
     */
    private Long sourceRelationId;

    /**
     * 连续签到天数
     */
    private Integer continueDay;

    /**
     * 上次签到开始时间
     */
    private Date beginLastSignDay;

    /**
     * 上次签到结束时间
     */
    private Date endLastSignDay;

    public SignStaticsQueryParam(){}

    public SignStaticsQueryParam(Long consumerId, SignSourceTypeEnum sourceType, Long sourceRelationId){
        this.consumerId = consumerId;
        this.sourceType = sourceType;
        this.sourceRelationId = sourceRelationId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public SignSourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SignSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Date getBeginLastSignDay() {
        return beginLastSignDay;
    }

    public void setBeginLastSignDay(Date beginLastSignDay) {
        this.beginLastSignDay = beginLastSignDay;
    }

    public Date getEndLastSignDay() {
        return endLastSignDay;
    }

    public void setEndLastSignDay(Date endLastSignDay) {
        this.endLastSignDay = endLastSignDay;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return "SignStaticsQueryParam{" +
                "consumerId=" + consumerId +
                ", appId=" + appId +
                ", sourceType=" + sourceType +
                ", sourceRelationId=" + sourceRelationId +
                ", continueDay=" + continueDay +
                ", beginLastSignDay=" + beginLastSignDay +
                ", endLastSignDay=" + endLastSignDay +
                '}';
    }
}
