package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.sign.center.api.dto.SignPetActivityToyDto;
import cn.com.duiba.sign.center.api.dto.SignPetPurchasedToyDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ToyTypeEnum;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/5/15
 * @description: 宠物道具
 */
@AdvancedFeignClient
public interface RemoteSignPetToyService {

    /**
     * 道具兑换
     * @param app
     * @param consumerDto
     * @param actToyId
     * @param ip
     * @param transfer
     */
    void createExchangeOrder(AppSimpleDto app, ConsumerDto consumerDto, Long actToyId,String ip, String transfer) throws BizException;

    /**
     * 查询道具商店展示的道具
     * @param actId
     * @return
     */
    List<SignPetActivityToyDto> selectActToy(Long actId, SignActivityTypeEnum actType);

    /**
     * 查询宠物拥有的道具
     * @param petId
     * @return
     */
    List<SignPetPurchasedToyDto> selectUserToy(Long petId, Long consumerId, ToyTypeEnum toyType);

    /**
     * 查询宠物正在使用的道具
     * @param petId
     * @return
     */
    List<SignPetPurchasedToyDto> selectUsingToy(Long petId,Long consumerId);
}
