package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityStatusEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignStatusEnum;
import cn.com.duiba.sign.center.api.enums.signpet.PetFeedTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetActivityDto implements Serializable{
    private static final long serialVersionUID = -5836786643935952493L;

    /**
     * id
     **/
    private Long id;
    /**
     * 是否已经入库
     */
    private boolean hasOperating = false;
    /**
     * 活动名称
     **/
    private String activityName;
    /**
     * 喂养类型
     */
    private PetFeedTypeEnum feedType;
    /**
     * 食物名称
     **/
    private String foodName;
    /**
     * 饭量
     */
    private Integer appetiteAmount;
    /**
     * 单次投掷粮食量限制
     **/
    private Integer feedAmountLimit;
    /**
     * 每天投掷次数限制
     **/
    private Integer feedCountLimit;
    /**
     * 吃饱状态保留时间（分钟）
     **/
    private Integer fullStateDuration;
    /**
     *
     */
    private SignActivityStatusEnum actStatus;
    /**
     * 规则描述
     */
    private String ruleDesc;
    /**
     * 宠物等级开启状态
     */
    private Boolean levelOpenStatus;
    /**
     * 每份包含粮食
     */
    private Integer foodPileUnit;
    /**
     * 食物份数上限
     */
    private Integer foodPileLimit;
    /**
     * 初始粮食数量
     */
    private Integer initFoodAmount;
    /**
     * 食物存储上限
     */
    private Integer foodAmountStoreLimit;
    /**
     * 自动生产粮食开启状态
     */
    private Boolean autoProductFoodOpenStatus;
    /**
     * 自动生产粮食时间间隔
     */
    private Integer autoProductFoodInterval;
    /**
     * 创建时间
     **/
    private Date gmtCreate;
    /**
     * 修改时间
     **/
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean hasOperating() {
        return hasOperating;
    }

    public void setHasOperating(boolean hasOperating) {
        this.hasOperating = hasOperating;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public PetFeedTypeEnum getFeedType() {
        return feedType;
    }

    public void setFeedType(PetFeedTypeEnum feedType) {
        this.feedType = feedType;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getAppetiteAmount() {
        return appetiteAmount;
    }

    public void setAppetiteAmount(Integer appetiteAmount) {
        this.appetiteAmount = appetiteAmount;
    }

    public Integer getFeedAmountLimit() {
        return feedAmountLimit;
    }

    public void setFeedAmountLimit(Integer feedAmountLimit) {
        this.feedAmountLimit = feedAmountLimit;
    }

    public Integer getFeedCountLimit() {
        return feedCountLimit;
    }

    public void setFeedCountLimit(Integer feedCountLimit) {
        this.feedCountLimit = feedCountLimit;
    }

    public Integer getFullStateDuration() {
        return fullStateDuration;
    }

    public void setFullStateDuration(Integer fullStateDuration) {
        this.fullStateDuration = fullStateDuration;
    }

    public SignActivityStatusEnum getActStatus() {
        return actStatus;
    }

    public void setActStatus(SignActivityStatusEnum actStatus) {
        this.actStatus = actStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getRuleDesc() {
        return ruleDesc;
    }

    public void setRuleDesc(String ruleDesc) {
        this.ruleDesc = ruleDesc;
    }

    public Boolean getLevelOpenStatus() {
        return levelOpenStatus;
    }

    public void setLevelOpenStatus(Boolean levelOpenStatus) {
        this.levelOpenStatus = levelOpenStatus;
    }

    public boolean isHasOperating() {
        return hasOperating;
    }

    public Integer getFoodPileUnit() {
        return foodPileUnit;
    }

    public void setFoodPileUnit(Integer foodPileUnit) {
        this.foodPileUnit = foodPileUnit;
    }

    public Integer getFoodPileLimit() {
        return foodPileLimit;
    }

    public void setFoodPileLimit(Integer foodPileLimit) {
        this.foodPileLimit = foodPileLimit;
    }

    public Integer getInitFoodAmount() {
        return initFoodAmount;
    }

    public void setInitFoodAmount(Integer initFoodAmount) {
        this.initFoodAmount = initFoodAmount;
    }

    public Integer getFoodAmountStoreLimit() {
        return foodAmountStoreLimit;
    }

    public void setFoodAmountStoreLimit(Integer foodAmountStoreLimit) {
        this.foodAmountStoreLimit = foodAmountStoreLimit;
    }

    public Boolean getAutoProductFoodOpenStatus() {
        return autoProductFoodOpenStatus;
    }

    public void setAutoProductFoodOpenStatus(Boolean autoProductFoodOpenStatus) {
        this.autoProductFoodOpenStatus = autoProductFoodOpenStatus;
    }

    public Integer getAutoProductFoodInterval() {
        return autoProductFoodInterval;
    }

    public void setAutoProductFoodInterval(Integer autoProductFoodInterval) {
        this.autoProductFoodInterval = autoProductFoodInterval;
    }

    @Override
    public String toString() {
        return "SignPetActivityDto{" +
                "id=" + id +
                ", hasOperating=" + hasOperating +
                ", activityName='" + activityName + '\'' +
                ", feedType=" + feedType +
                ", foodName='" + foodName + '\'' +
                ", appetiteAmount=" + appetiteAmount +
                ", feedAmountLimit=" + feedAmountLimit +
                ", feedCountLimit=" + feedCountLimit +
                ", fullStateDuration=" + fullStateDuration +
                ", actStatus=" + actStatus +
                ", ruleDesc='" + ruleDesc + '\'' +
                ", levelOpenStatus=" + levelOpenStatus +
                ", foodPileUnit=" + foodPileUnit +
                ", foodPileLimit=" + foodPileLimit +
                ", initFoodAmount=" + initFoodAmount +
                ", foodAmountStoreLimit=" + foodAmountStoreLimit +
                ", autoProductFoodOpenStatus=" + autoProductFoodOpenStatus +
                ", autoProductFoodInterval=" + autoProductFoodInterval +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
