package cn.com.duiba.sign.center.api.enums.creditssign;


import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 2017/5/31.
 */
public enum SignCalendarResponseTypeEnum {

    PROMPT_TYPE(1,"文案提示"),
    REDIRECT_TYPE(2,"跳转链接"),
    HTML_TYPE(3,"唤起弹层"),
    LinkGROUP_TYPE(4,"多链接模式");

    private Integer code;
    private String desc;

    private static Map<Integer,SignCalendarResponseTypeEnum> typeMap = new HashMap<>();
    static{
        for(SignCalendarResponseTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    SignCalendarResponseTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static SignCalendarResponseTypeEnum getResponseTypeByCode(Integer code){
        if(code == null || !typeMap.containsKey(code)){
            throw new SignCenterException("不支持的签到日历相应类型,code="+code);
        }
        return typeMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
