package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetActivityToyDto;
import cn.com.duiba.sign.center.api.enums.signpet.ToyTypeEnum;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/5/16
 * @description:
 */
@AdvancedFeignClient
public interface RemoteSignPetActToyService {
    /**
     * 主键查询
     * @param toyId
     * @return
     */
    SignPetActivityToyDto findById(Long toyId);

    /**
     * 修改
     * @param dto
     * @return
     */
    Integer updateById(SignPetActivityToyDto dto);

    /**
     * 插入
     * @param dto
     * @return
     */
    Long insert(SignPetActivityToyDto dto);

    /**
     * 分页查询
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<SignPetActivityToyDto> pageList(int pageNum,int pageSize);

    /**
     * 总数查询
     * @return
     */
    Integer countAll();

    /**
     * 总数查询
     * @return
     */
    Integer countByActAndType(Long actId, ToyTypeEnum type);
}
