package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signrecord.SignRemindUserDto;
import cn.com.duiba.sign.center.api.params.PageParams;
import cn.com.duiba.sign.center.api.params.SignRemindUserQueryParam;

import java.util.List;

/**
 * Created by fangdong on 2019/09/02
 */
@AdvancedFeignClient
public interface RemoteSignRemindUserService {

    /**
     * 根据id查询
     * @param id 主键
     * @return 签到提醒用户
     * @throws BizException
     */
    SignRemindUserDto getById(Long id);

    /**
     * 根据id查询
     * @param id 主键
     * @return 签到提醒用户
     * @throws BizException
     */
    SignRemindUserDto getByUniqueKey(SignRemindUserQueryParam param);

    List<SignRemindUserDto> page(SignRemindUserQueryParam param, PageParams query);

    /**
     * 保存
     * @param remindUser 签到提醒用户
     * @return 主键
     * @throws BizException
     */
    Long insert(SignRemindUserDto remindUser) throws BizException;


    Integer deleteById(Long id) throws Exception;
}
