package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignWanderActivityDto;

import java.util.List;

/**
 * @author leihu
 * @date created in 2018/6/5
 * @description:
 */
@AdvancedFeignClient
public interface RemoteSignWanderActivityService {

    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return
     */
    Long insert(SignWanderActivityDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    Boolean delete(Long id);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int update(SignWanderActivityDto dto);

    /**
     * 根据主键查询对应数据条目
     * @param id
     * @return
     */
    SignWanderActivityDto find(Long id);
    /**
     * 分页查询
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<SignWanderActivityDto> pageList(Integer pageNo, Integer pageSize,String actName);

    /**
     * 查询总数
     * @return
     */
    Integer countAll(String actName);

}
