package cn.com.duiba.sign.center.api.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @Author chenxiangge
 * @Date 2019/4/29
 */
public class GenPokerUtil {
    private GenPokerUtil() {
        throw new IllegalStateException("Utility class");
    }
    /**
     * 表示黑桃花色
     */
    private static final int SPADE = 1;
    /**
     * 表示梅花花色
     */
    private static final int CLUB = 2;
    /**
     * 表示红桃花色
     */
    private static final int HEART = 3;
    /**
     * 表示方片花色
     */
    private static final int DIAMOND = 4;

    /**
     * 表示整副牌
     */
    private static final ImmutableSet<Integer> POKER;

    static {
        List<Integer> list = Lists.newArrayList();
        for (int i = 1; i < 14; i++) {
            list.add(i * 10 + SPADE);
            list.add(i * 10 + CLUB);
            list.add(i * 10 + HEART);
            list.add(i * 10 + DIAMOND);
        }
        POKER = ImmutableSet.copyOf(list);
    }

    public static Integer getRandomFromFull() {
        Random random = new Random();
        return POKER.asList().get(random.nextInt(52));
    }

    public static Integer getRandomCardExpectInput(Integer card) {
        if (null == card) {
            return null;
        }
        Integer result = getRandomFromFull();
        while (result.equals(card)) {
            result = getRandomFromFull();
        }
        return result;

    }

    public static List<Integer> getRandomCards(int cardCount) {
        List<Integer> cards = new ArrayList<>();
        if (cardCount <= 0) {
            return cards;
        }
        for (int i = 0; i < cardCount; i++) {
            cards.add(getRandomFromFull());
        }
        return cards;
    }

    public static String generateMatchCard(List<Integer> matchCards, int matchCardCount) {
        if (matchCardCount > matchCards.size()) {
            return null;
        }

        if (matchCardCount < 0 || CollectionUtils.isEmpty(matchCards)) {
            return null;
        }

        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < matchCardCount; i++) {
            prefix.append(matchCards.get(i)).append("_");
        }

        StringBuilder result = prefix;
        for (int i = matchCardCount; i < matchCards.size(); i++) {
            result.append(getRandomCardExpectInput(matchCards.get(i))).append("_");
        }

        //删除最后一个——
        String resultStr = result.toString();
        if (StringUtils.endsWith(resultStr, "_")) {
            resultStr = result.toString().substring(0, resultStr.length() - 1);
        }

        return resultStr;
    }
}
